/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public class CpnetServer {
    public CpnetServerConfig cfgTab = new CpnetServerConfig();
    public OutputStream[] lsts = new OutputStream[16];
    public int[] lstCid = new int[16];
    public String dir = null;
    public String[] dirs = new String[16];

    public CpnetServer(Properties properties, String string, char c, byte by, int n, String string2) {
        String string3;
        Arrays.fill(this.lsts, null);
        Arrays.fill(this.lstCid, 255);
        this.cfgTab.tmp = (byte)(c - 65 & 0xF);
        this.cfgTab.sts = (byte)16;
        this.cfgTab.id = by;
        this.cfgTab.max = (byte)n;
        this.dir = string2;
        for (int i = 0; i < 16; ++i) {
            String string4 = String.format("%s_drive_%c", string, Character.valueOf((char)(97 + i)));
            string3 = properties.getProperty(string4);
            if (string3 == null || string3.length() == 0) continue;
            File file = new File(string3);
            if (!file.exists()) {
                try {
                    file.mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!file.exists() || !file.isDirectory()) {
                System.err.format("HostFileBdos invalid path in %s: %s\n", string4, string3);
                continue;
            }
            this.dirs[i] = string3;
        }
        String string5 = string;
        string5 = string5 + "_lst";
        int n2 = string5.length();
        for (String string6 : properties.stringPropertyNames()) {
            int n3;
            if (!string6.startsWith(string5)) continue;
            string3 = properties.getProperty(string6);
            try {
                n3 = Integer.valueOf(string6.substring(n2), 16);
            }
            catch (Exception exception) {
                System.err.format("Invalid List ID, skipping %s\n", string3);
                continue;
            }
            if (n3 < 0 || n3 >= 16) {
                System.err.format("Invalid List ID %01lx: skipping %s\n", n3, string3);
                continue;
            }
            if (string3.length() == 0) {
                System.err.format("Empty List property %s\n", string6);
                continue;
            }
            System.err.format("List %01x: %s\n", n3, string3);
            this.initLst(properties, n3, string3);
        }
    }

    private void initLst(Properties properties, int n, String string) {
        if (string.charAt(0) == '>') {
            this.attachFile(n, string.substring(1));
        } else if (string.charAt(0) == '|') {
            this.attachPipe(n, string.substring(1));
        } else {
            this.attachClass(properties, n, string);
        }
    }

    private void attachFile(int n, String string) {
        String[] stringArray = string.split("\\s");
        try {
            this.lsts[n] = new FileOutputStream(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.format("Invalid file in attachment: %s\n", string);
            return;
        }
    }

    private void attachPipe(int n, String string) {
        System.err.format("Pipe attachments not yet implemented: %s\n", string);
    }

    private void attachClass(Properties properties, int n, String string) {
        String[] stringArray = string.split("\\s");
        Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
        try {
            Class<?> clazz = Class.forName(stringArray[0]);
            Constructor<?> constructor = clazz.getConstructor(Properties.class, vector.getClass());
            this.lsts[n] = (OutputStream)constructor.newInstance(properties, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.format("Invalid class in attachment: \"%s\"\n", stringArray[0]);
            return;
        }
    }

    public synchronized boolean acquireLst(int n, int n2) {
        if (this.cfgTab.max == 1) {
            return true;
        }
        if (this.lstCid[n2] == n) {
            return true;
        }
        if (this.lstCid[n2] != 255) {
            return false;
        }
        this.lstCid[n2] = n;
        return true;
    }

    public synchronized void releaseLst(int n, int n2) {
        this.lstCid[n2] = 255;
    }

    public synchronized boolean addClient(int n) {
        if (this.cfgTab.cur >= this.cfgTab.max) {
            return false;
        }
        int n2 = 16;
        for (int i = 0; i < 16; ++i) {
            if ((this.cfgTab.rid[i] & 0xFF) == n) {
                return true;
            }
            if ((this.cfgTab.vec & 1 << i) != 0 || n2 < 16) continue;
            n2 = i;
        }
        if (n2 >= 16) {
            return false;
        }
        this.cfgTab.cur = (byte)(this.cfgTab.cur + 1);
        this.cfgTab.vec = (short)(this.cfgTab.vec | 1 << n2);
        this.cfgTab.rid[n2] = (byte)n;
        return true;
    }

    public synchronized boolean chkClient(int n) {
        for (int i = 0; i < 16; ++i) {
            if ((this.cfgTab.rid[i] & 0xFF) != n) continue;
            return true;
        }
        return false;
    }

    public synchronized int rmClient(int n) {
        int n2;
        for (n2 = 0; n2 < 16 && (this.cfgTab.rid[n2] & 0xFF) != n; ++n2) {
        }
        if (n2 < 16) {
            this.cfgTab.cur = (byte)(this.cfgTab.cur - 1);
            this.cfgTab.vec = (short)(this.cfgTab.vec & ~(1 << n2));
            this.cfgTab.rid[n2] = -1;
            return 0;
        }
        return -1;
    }

    public synchronized void shutdown(int n) {
        for (int i = 0; i < this.lstCid.length; ++i) {
            if (this.lstCid[i] != n) continue;
            this.releaseLst(n, i);
        }
        this.rmClient(n);
    }
}

