/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CpnetSocketServer
implements Runnable {
    private static CpnetSocketServer thus;
    private static final int vers = 3;
    Properties props = new Properties();
    int srvId = 255;
    String dir = null;
    ServerSocket ssock;
    String host = null;
    int port = 255;
    String prefix = "cpnetserver";
    boolean magnet;
    boolean debug;
    CpnetServer srv;
    Vector<Pattern> black;
    Vector<IPAddrMask> range;
    private int dmp = 0;

    public static void main(String[] stringArray) {
        thus = new CpnetSocketServer(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    public CpnetSocketServer(String[] stringArray) {
        String string;
        int n;
        Object object;
        Object object2 = null;
        Object object3 = null;
        Object object4 = "16";
        int n2 = 0;
        int n3 = 255;
        char c = 'P';
        Object object5 = null;
        this.black = new Vector();
        this.range = new Vector();
        boolean bl = false;
        String string2 = System.getenv("CPNET_CONFIG");
        if (string2 == null && ((File)(object = new File("./cpnetrc"))).exists()) {
            string2 = ((File)object).getAbsolutePath();
        }
        if (string2 == null) {
            string2 = System.getProperty("user.home") + "/.cpnetrc";
        }
        for (String string3 : stringArray) {
            if (!string3.startsWith("conf=")) continue;
            string2 = string3.substring(5);
        }
        try {
            object = new FileInputStream(string2);
            this.props.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            string2 = null;
        }
        object = this.props.getProperty(this.prefix + "_log");
        if (object != null) {
            object5 = object;
        }
        String[] object6 = stringArray;
        int n4 = object6.length;
        for (n = 0; n < n4; ++n) {
            String string4 = object6[n];
            if (!string4.startsWith("log=")) continue;
            object5 = string4.substring(4);
        }
        if (object5 != null) {
            try {
                FileOutputStream exception = new FileOutputStream((String)object5, false);
                PrintStream printStream = new PrintStream(exception, true);
                System.setErr(printStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((object = this.props.getProperty(this.prefix + "_log_time")) != null) {
            StampPrintStream exception = new StampPrintStream(System.err);
            System.setErr(exception);
        }
        System.err.format("CpnetSocketServer v1.%d\n", 3);
        if (string2 != null) {
            System.err.format("Using config in %s\n", string2);
        } else {
            System.err.format("No config file\n", new Object[0]);
        }
        this.magnet = false;
        object = this.props.getProperty(this.prefix + "_magnet");
        if (object != null) {
            this.magnet = true;
        }
        if ((object = this.props.getProperty(this.prefix + "_host")) != null) {
            this.host = object;
        }
        if ((object = this.props.getProperty(this.prefix + "_port")) != null) {
            object2 = object;
        }
        if ((object = this.props.getProperty(this.prefix + "_temp")) != null) {
            if (((String)object).length() != 1 || !Character.isLetter(((String)object).charAt(0))) {
                System.err.format("Invalid temp drive configured\n", new Object[0]);
                System.exit(1);
            }
            c = Character.toUpperCase(((String)object).charAt(0));
        }
        if ((object = this.props.getProperty(this.prefix + "_sid")) != null) {
            object3 = object;
        }
        if ((object = this.props.getProperty(this.prefix + "_max")) != null) {
            object4 = object;
        }
        if ((object = this.props.getProperty(this.prefix + "_root_dir")) != null) {
            this.dir = object;
        }
        this.debug = (object = this.props.getProperty(this.prefix + "_debug")) != null;
        object = this.props.getProperty(this.prefix + "_blacklist");
        if (object != null) {
            String[] stringArray2;
            String[] stringArray3 = stringArray2 = ((String)object).split("\\s");
            n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                string = stringArray3[i];
                if (string.length() < 3) {
                    System.err.format("Illegal blacklist \"%s\"\n", string);
                    continue;
                }
                try {
                    this.parseBlacklist(string);
                    continue;
                }
                catch (Exception exception) {
                    System.err.format("Invalid blacklist \"%s\" (%s)\n", string);
                }
            }
        }
        for (String string5 : stringArray) {
            if (string5.startsWith("host=")) {
                this.host = string5.substring(5);
                continue;
            }
            if (string5.startsWith("port=")) {
                object2 = string5.substring(5);
                continue;
            }
            if (string5.startsWith("temp=")) {
                string = string5.substring(5);
                if (string.length() != 1 || !Character.isLetter(string.charAt(0))) {
                    System.err.format("Invalid temp drive specified\n", new Object[0]);
                    System.exit(1);
                }
                c = Character.toUpperCase(string.charAt(0));
                continue;
            }
            if (string5.startsWith("sid=")) {
                object3 = string5.substring(4);
                continue;
            }
            if (string5.startsWith("max=")) {
                object4 = string5.substring(4);
                continue;
            }
            if (string5.startsWith("dir=")) {
                this.dir = string5.substring(4);
                continue;
            }
            if (string5.equalsIgnoreCase("magnet")) {
                this.magnet = true;
                continue;
            }
            if (string5.equalsIgnoreCase("wait")) {
                bl = true;
                continue;
            }
            if (!string5.equalsIgnoreCase("debug")) continue;
            this.debug = true;
        }
        if (this.dir == null) {
            this.dir = System.getProperty("user.home") + "/HostFileBdos";
        }
        if (object2 != null) {
            try {
                this.port = Integer.decode((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.port <= 0 || this.host == null) {
            System.err.format("No valid host/port specified or configured\n", new Object[0]);
            System.exit(1);
        }
        try {
            n3 = Integer.valueOf((String)object3, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n3 < 0 || n3 >= 255) {
            System.err.format("No valid server ID specified or configured\n", new Object[0]);
            System.exit(1);
        }
        try {
            n2 = Integer.valueOf((String)object4, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 <= 0) {
            n2 = 1;
        } else if (n2 > 16) {
            n2 = 16;
        }
        Object var12_29 = null;
        try {
            if (this.host.length() == 0 || this.host.equalsIgnoreCase("localhost")) {
                InetAddress inetAddress = InetAddress.getByName(null);
            } else {
                InetAddress inetAddress = InetAddress.getByName(this.host);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.ssock = null;
        while (this.ssock == null) {
            try {
                void var12_33;
                this.ssock = new ServerSocket(this.port, 1, (InetAddress)var12_33);
            }
            catch (Exception exception) {
                if (bl && exception instanceof BindException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception2) {}
                    continue;
                }
                exception.printStackTrace();
                System.exit(1);
            }
        }
        this.srvId = n3;
        this.srv = new CpnetServer(this.props, this.prefix, c, (byte)n3, n2, this.dir);
        Thread thread = new Thread(this);
        thread.start();
    }

    private void parseBlacklist(String string) throws Exception {
        String[] stringArray = string.split("/");
        if (stringArray.length > 1) {
            int n = Integer.valueOf(stringArray[1]);
            if (n <= 0 || n > 32) {
                throw new NumberFormatException("net mask");
            }
            int n2 = -1 << 32 - n;
            InetAddress inetAddress = InetAddress.getByName(stringArray[0]);
            this.range.add(new IPAddrMask(inetAddress, n2));
        } else {
            String string2 = Pattern.quote(string);
            if (string.charAt(0) == '.') {
                string2 = ".*" + string2;
            }
            this.black.add(Pattern.compile(string2));
        }
        System.err.format("Blacklisting \"%s\"\n", string);
    }

    private void reject(String string, Socket socket) {
        System.err.format("Rejecting blacklisted \"%s\"\n", string);
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dumpMsg(byte[] byArray, int n) {
        if (this.magnet) {
            this.dmp += ServerDispatch.getBC(byArray);
            this.dmp &= 0x3FF;
            System.err.format("[%04x] %02x %04x %04x %04x:%02x %02x %02x %02x %02x %02x ...\n", this.dmp, ServerDispatch.getCode(byArray), ServerDispatch.getBC(byArray), ServerDispatch.getDE(byArray), ServerDispatch.getHL(byArray), byArray[7] & 0xFF, byArray[8] & 0xFF, byArray[9] & 0xFF, byArray[10] & 0xFF, byArray[11] & 0xFF, byArray[12] & 0xFF);
        } else {
            String string = String.format("%02x %02x %02x %02x %02x:%02x", byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF, byArray[3] & 0xFF, byArray[4] & 0xFF, byArray[5] & 0xFF);
            for (int i = 6; i < n; ++i) {
                string = string + String.format(" %02x", byArray[i] & 0xFF);
            }
            System.err.format("%s\n", string);
        }
    }

    @Override
    public void run() {
        System.err.format("Server %02x Listening on %s port %d debug %s\n", this.srvId, this.host, this.port, this.debug);
        try {
            while (true) {
                Socket socket = this.ssock.accept();
                new CpnetSocketServerConnection(socket);
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    class CpnetSocketServerConnection
    implements Runnable {
        Socket sock;
        InputStream in;
        OutputStream out;
        HostFileBdos hfb = null;
        NetworkBoot nwb;
        NetworkDump nwd;
        String remote;
        int cltId;
        byte[] buf = new byte[268];

        public CpnetSocketServerConnection(Socket socket) {
            int n;
            InetAddress inetAddress;
            try {
                socket.setKeepAlive(true);
                inetAddress = socket.getInetAddress();
                this.remote = inetAddress.getCanonicalHostName();
                n = socket.getLocalPort();
                this.in = socket.getInputStream();
                this.out = socket.getOutputStream();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            for (IPAddrMask object : CpnetSocketServer.this.range) {
                if (!object.matches(inetAddress)) continue;
                CpnetSocketServer.this.reject(this.remote, socket);
                return;
            }
            for (Pattern pattern : CpnetSocketServer.this.black) {
                Matcher matcher = pattern.matcher(this.remote);
                if (!matcher.matches()) continue;
                CpnetSocketServer.this.reject(this.remote, socket);
                return;
            }
            this.sock = socket;
            this.cltId = 255;
            System.err.format("Connection from %s (%d)\n", this.remote, n);
            Thread thread = new Thread(this);
            thread.start();
        }

        private boolean newClient() {
            int n;
            int n2;
            int n3 = (this.buf[4] & 0xFF) + 1;
            if (CpnetSocketServer.this.magnet) {
                n2 = this.buf[3] & 0xFF;
                n = this.buf[4] & 0xFF;
            } else {
                n2 = this.buf[2] & 0xFF;
                n = this.buf[1] & 0xFF;
            }
            if (n != CpnetSocketServer.this.srvId) {
                System.err.format("SID mismatch %02x != %02x\n", n, CpnetSocketServer.this.srvId);
                if (CpnetSocketServer.this.debug) {
                    CpnetSocketServer.this.dumpMsg(this.buf, n3);
                }
                return false;
            }
            if (n2 == CpnetSocketServer.this.srvId || n2 < 0 || n2 >= 255) {
                System.err.format("CID invalid %02x\n", n2);
                if (CpnetSocketServer.this.debug) {
                    CpnetSocketServer.this.dumpMsg(this.buf, n3);
                }
                return false;
            }
            this.cltId = n2;
            System.err.format("Remote %s is %02x\n", this.remote, this.cltId);
            Vector<String> vector = new Vector<String>();
            this.hfb = CpnetSocketServer.this.magnet ? new MagNetHFB(CpnetSocketServer.this.props, CpnetSocketServer.this.prefix, vector, n2, CpnetSocketServer.this.srv) : new HostFileBdos(CpnetSocketServer.this.props, CpnetSocketServer.this.prefix, vector, n2, CpnetSocketServer.this.srv);
            return true;
        }

        private void shutdown() {
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.err.format("Disconnected from %s (%02x)\n", this.remote, this.cltId);
            if (this.hfb != null) {
                this.hfb.shutdown();
            }
        }

        private byte[] startBoot(byte[] byArray) {
            this.nwb = NetworkBoot.doStart(CpnetSocketServer.this.props, byArray);
            if (this.nwb == null) {
                return NetworkBoot.error(byArray);
            }
            return this.nwb.doNext(byArray);
        }

        private byte[] startDump(byte[] byArray) {
            this.nwd = NetworkDump.doStart(CpnetSocketServer.this.props, byArray);
            if (this.nwd == null) {
                return NetworkDump.error(byArray);
            }
            return this.nwd.doNext(byArray);
        }

        private byte[] processMsg(byte[] byArray, int n) {
            int n2 = byArray[0] & 0xFF;
            switch (n2) {
                case 0: {
                    return this.hfb.sendMsg(byArray, n);
                }
                case 176: {
                    if (this.nwb == null) {
                        return this.startBoot(byArray);
                    }
                    byte[] byArray2 = this.nwb.doNext(byArray);
                    if (this.nwb.done()) {
                        this.nwb = null;
                    }
                    return byArray2;
                }
                case 208: {
                    if (this.nwd == null) {
                        return this.startDump(byArray);
                    }
                    byte[] byArray3 = this.nwd.doNext(byArray);
                    if (this.nwd.done()) {
                        this.nwd = null;
                    }
                    return byArray3;
                }
            }
            byArray[0] = (byte)(byArray[0] | 1);
            byte by = byArray[2];
            byArray[2] = byArray[1];
            byArray[1] = by;
            byArray[4] = 1;
            byArray[5] = -1;
            byArray[6] = 12;
            return byArray;
        }

        @Override
        public void run() {
            int n = 0;
            int n2 = 0;
            while (true) {
                byte[] byArray;
                int n3 = 0;
                try {
                    n3 = this.in.read(this.buf, n, this.buf.length - n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    n3 = -1;
                }
                if (n3 < 0) {
                    this.shutdown();
                    return;
                }
                n += n3;
                if (n2 == 0) {
                    if (!CpnetSocketServer.this.magnet) {
                        if (n < 5) continue;
                        n2 = this.buf[4] & 0xFF;
                        n2 += 6;
                    } else {
                        if (n < 7) continue;
                        n2 = ServerDispatch.getBC(this.buf) + 7;
                    }
                    if (this.hfb == null && !this.newClient()) {
                        this.shutdown();
                        return;
                    }
                }
                if (n2 == 0 || n < n2) continue;
                if (CpnetSocketServer.this.debug) {
                    CpnetSocketServer.this.dumpMsg(this.buf, n2);
                }
                int n4 = 0;
                if (!CpnetSocketServer.this.magnet) {
                    byArray = this.processMsg(this.buf, n2);
                    n3 = (byArray[4] & 0xFF) + 1;
                    n3 += 5;
                } else {
                    byArray = this.hfb.sendMsg(this.buf, n2);
                    int n5 = ServerDispatch.getCode(byArray);
                    n3 = 7;
                    if (n5 == 1 || n5 == 16) {
                        n3 += ServerDispatch.getBC(byArray);
                    } else if (n5 == 48) {
                        n3 += 65;
                    }
                }
                try {
                    if (CpnetSocketServer.this.debug) {
                        CpnetSocketServer.this.dumpMsg(byArray, n3);
                    }
                    this.out.write(byArray, n4, n3);
                    this.out.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.shutdown();
                    return;
                }
                n2 = 0;
                n = 0;
            }
        }
    }

    class StampPrintStream
    extends PrintStream {
        PrintStream ps;
        SimpleDateFormat tagFmt;

        public StampPrintStream(PrintStream printStream) {
            super(printStream);
            this.tagFmt = null;
            this.ps = printStream;
            this.tagFmt = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS");
        }

        @Override
        public PrintStream format(String string, Object ... objectArray) {
            string = this.tagFmt.format(new Date()) + " " + string;
            this.ps.format(string, objectArray);
            return this;
        }
    }

    class IPAddrMask {
        int addr;
        int mask;

        public IPAddrMask(InetAddress inetAddress, int n) {
            this.mask = n;
            this.addr = this.getAddr(inetAddress);
        }

        private int getAddr(InetAddress inetAddress) {
            byte[] byArray = inetAddress.getAddress();
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n <<= 8;
                if (i >= byArray.length) continue;
                n |= byArray[i] & 0xFF;
            }
            return n;
        }

        public boolean matches(InetAddress inetAddress) {
            int n = this.getAddr(inetAddress);
            return ((n ^ this.addr) & this.mask) == 0;
        }
    }
}

