/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

public class NetBootLdr
implements NetBoot {
    static final int BIOSPG = 0;
    static final int BDOSPG = 1;
    static final int MAPS = 2;
    static final int RECLEN = 128;
    private String dir;
    private String def;
    private int nid;
    private int sid;
    private int bios_pg;
    private int bdos_pg;
    private int snios_pg;
    private int ndos_pg;
    private int entry;
    private int cfgtbl;
    private int curdma;
    private int reccnt;
    private boolean org0;
    private File lastFile;
    private String ldmsg;
    private String sniosFile;
    private String ndosFile;
    private byte[] image;
    private Map<Integer, Integer> maps = new HashMap<Integer, Integer>();

    public NetBootLdr(String string, String string2, byte[] byArray) throws Exception {
        this.dir = string;
        this.def = string2;
        this.nid = byArray[2] & 0xFF;
        this.sid = byArray[1] & 0xFF;
        this.bios_pg = (byArray[5] & 0xFF) << 8;
        this.bdos_pg = (byArray[6] & 0xFF) << 8;
        int n = (byArray[4] & 0xFF) + 1;
        int n2 = 2;
        while (n2 + 1 < n && (byArray[5 + n2] & 0x80) != 0) {
            int n3 = byArray[5 + n2] & 0xF;
            int n4 = byArray[5 + n2 + 1] & 0xFF;
            this.maps.put(n4, n3 << 8 | this.sid);
            n2 += 2;
        }
        String string3 = "";
        if (n - n2 > 2) {
            string3 = new String(byArray, 5 + n2 + 1, n - n2 - 2).toLowerCase();
        }
        byte[] byArray2 = this.loadSpr(string3, "snios");
        this.sniosFile = this.lastFile.getAbsolutePath();
        this.cfgtbl = this.getCfgTbl(byArray2);
        this.setCfgTbl(this.maps, byArray2);
        this.fixCfgTbl(byArray2);
        byte[] byArray3 = this.loadSpr(string3, "ndos");
        this.ndosFile = this.lastFile.getAbsolutePath();
        this.snios_pg = this.bdos_pg - this.lengthSpr(byArray2);
        this.ndos_pg = this.snios_pg - this.lengthSpr(byArray3);
        this.relocSpr(this.snios_pg, byArray2);
        this.relocSpr(this.ndos_pg, byArray3);
        this.image = new byte[this.lengthSpr(byArray2) + this.lengthSpr(byArray3)];
        System.arraycopy(byArray3, 256, this.image, 0, this.lengthSpr(byArray3));
        System.arraycopy(byArray2, 256, this.image, this.lengthSpr(byArray3), this.lengthSpr(byArray2));
        this.ldmsg = String.format("BIOS        %04X %04X\r\nBDOS        %04X %04X\r\nSNIOS   SPR %04X %04X\r\nNDOS    SPR %04X %04X\r\n\n%dK TPA$", this.bios_pg, 65536 - this.bios_pg, this.bdos_pg, this.bios_pg - this.bdos_pg, this.snios_pg, this.bdos_pg - this.snios_pg, this.ndos_pg, this.snios_pg - this.ndos_pg, this.ndos_pg >> 10);
        this.entry = this.ndos_pg + 3;
        this.org0 = false;
        System.err.format("Client %02x loading CP/NET from %s, %s\n", this.nid, this.ndosFile, this.sniosFile);
    }

    private int sizeSpr(byte[] byArray) {
        int n = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
        return n;
    }

    private int lengthSpr(byte[] byArray) {
        int n = this.sizeSpr(byArray);
        n = n + 255 & 0xFF00;
        return n;
    }

    private byte[] loadSpr(String string, String string2) throws Exception {
        byte[] byArray = null;
        File file = null;
        if (string.length() > 0) {
            file = new File(String.format("%s/%s%02X%s.spr", this.dir, string2, this.nid, string));
            if (!file.exists()) {
                file = new File(String.format("%s/%s%s.spr", this.dir, string2, string));
            }
        } else {
            file = new File(String.format("%s/%s%02X.spr", this.dir, string2, this.nid));
            if (!file.exists()) {
                file = new File(String.format("%s/%s.spr", this.dir, string2));
            }
        }
        this.lastFile = file;
        FileInputStream fileInputStream = new FileInputStream(file);
        byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void relocSpr(int n, byte[] byArray) {
        int n2 = this.sizeSpr(byArray);
        int n3 = n2 + 256;
        int n4 = n >> 8;
        for (int i = 0; i < n2; ++i) {
            int n5 = i & 7;
            int n6 = i >> 3;
            int n7 = byArray[n3 + n6] & 0xFF;
            if (n7 == 0) {
                i += 7;
                continue;
            }
            if ((n7 << n5 & 0x80) == 0) continue;
            int n8 = byArray[256 + i] & 0xFF;
            byArray[256 + i] = (byte)(n8 + n4);
        }
    }

    private int getCfgTbl(byte[] byArray) {
        int n = 262;
        if ((byArray[n] & 0xFF) != 195) {
            return -1;
        }
        n = byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8;
        if ((byArray[n += 256] & 0xFF) != 33) {
            return -1;
        }
        return byArray[n + 1] & 0xFF | (byArray[n + 2] & 0xFF) << 8;
    }

    private void setCfgTbl(Map<Integer, Integer> map, byte[] byArray) {
        if (this.cfgtbl < 0) {
            return;
        }
        int n = this.cfgtbl + 2;
        n += 256;
        for (int i = 0; i < 18; ++i) {
            if (!map.containsKey(i)) continue;
            int n2 = map.get(i);
            int n3 = n + i * 2;
            byArray[n3] = (byte)(n2 >> 8 | 0x80);
            byArray[n3 + 1] = (byte)n2;
        }
    }

    private void fixCfgTbl(byte[] byArray) {
        if (this.cfgtbl < 0) {
            return;
        }
        int n = this.cfgtbl + 2;
        n += 256;
        for (int i = 0; i < 18; ++i) {
            int n2 = i * 2;
            if ((byArray[n + n2] & 0x80) == 0 || (byArray[n + n2 + 1] & 0xFF) != 255) continue;
            byArray[n + n2 + 1] = (byte)this.sid;
        }
    }

    @Override
    public boolean hasRes() {
        return true;
    }

    @Override
    public boolean hasBnk() {
        return false;
    }

    @Override
    public void setLoadMsg(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.ldmsg.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    @Override
    public int startResAddr() {
        this.curdma = 0;
        this.reccnt = this.image.length / 128;
        return this.ndos_pg;
    }

    @Override
    public int nextResRec(byte[] byArray, int n, int n2) {
        System.arraycopy(this.image, this.curdma, byArray, 5, 128);
        this.curdma += 128;
        --this.reccnt;
        return this.reccnt;
    }

    @Override
    public int startBnkAddr() {
        return 0;
    }

    @Override
    public int nextBnkRec(byte[] byArray, int n, int n2) {
        return -1;
    }

    @Override
    public int entryAddr() {
        return this.entry;
    }

    @Override
    public boolean needsOrg0() {
        return this.org0;
    }
}

