/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class NetworkBoot {
    public static final int FMT = 176;
    static final int STATE_START = 0;
    static final int STATE_RESDMA = 1;
    static final int STATE_RESLD = 2;
    static final int STATE_BNKDMA = 3;
    static final int STATE_BNKLD = 4;
    static final int STATE_ORG0DMA = 5;
    static final int STATE_ORG0LD = 6;
    static final int STATE_DONE = 7;
    static final int MEMTOP = 0;
    static final int COMLEN = 1;
    static final int BNKTOP = 2;
    static final int BNKLEN = 3;
    static final int ENTRY = 4;
    static final int CNFTBL = 6;
    static final int COPY = 16;
    static final int SIGNON = 128;
    static final int IMAGE = 256;
    static final int RECLEN = 128;
    private int state = -1;
    private byte[] image;
    private byte[] org0;
    private int org0Adr;
    private int curdma;
    private int reccnt;
    private NetBoot netBoot;
    private byte[] resp;

    public NetworkBoot(NetBoot netBoot, byte[] byArray, int n, int n2) {
        this.netBoot = netBoot;
        this.org0 = byArray;
        this.org0Adr = n;
        this.resp = new byte[133];
        this.state = 0;
    }

    public static NetworkBoot doStart(Properties properties, byte[] byArray) {
        String string;
        String string2;
        if (byArray[3] != 1 && byArray[3] != 2) {
            System.err.format("Invalid boot FNC %02x\n", byArray[3] & 0xFF);
            return null;
        }
        String string3 = properties.getProperty("netboot_dir");
        if (string3 == null) {
            string3 = System.getProperty("user.home") + "/NetBoot";
        }
        if ((string2 = properties.getProperty("netboot_org0")) == null) {
            string2 = "org0boot.bin";
        } else if (string2.equalsIgnoreCase("none")) {
            string2 = null;
        }
        int n = 12288;
        String string4 = properties.getProperty("netboot_org0_adr");
        if (string4 != null) {
            n = Integer.decode(string4);
        }
        if ((string = properties.getProperty("netboot_default")) == null) {
            string = "defboot.sys";
        }
        byte[] byArray2 = null;
        NetBoot netBoot = null;
        try {
            netBoot = byArray[3] == 1 ? new NetBootSys(string3, string, byArray) : new NetBootLdr(string3, string, byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (string2 != null && netBoot.needsOrg0()) {
            File file = new File(string3 + "/" + string2);
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                byArray2 = new byte[fileInputStream.available()];
                fileInputStream.read(byArray2);
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        int n2 = byArray[1] & 0xFF;
        return new NetworkBoot(netBoot, byArray2, n, n2);
    }

    public static byte[] error(byte[] byArray) {
        return new byte[]{-79, byArray[2], byArray[1], 0, 0, 0};
    }

    public boolean done() {
        return this.state < 0 || this.state > 7;
    }

    public byte[] doNext(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        if (this.state != 0 && n != 0 || this.state == 0 && n != 1 && n != 2) {
            this.state = -1;
        }
        switch (this.state) {
            case 0: {
                this.resp[3] = 1;
                this.resp[4] = 127;
                this.netBoot.setLoadMsg(this.resp, 5, 128);
                if (this.netBoot.hasRes()) {
                    this.state = 1;
                    break;
                }
                this.state = 3;
                break;
            }
            case 1: {
                int n2 = this.netBoot.startResAddr();
                this.resp[3] = 2;
                this.resp[4] = 1;
                this.resp[5] = (byte)n2;
                this.resp[6] = (byte)(n2 >> 8);
                this.state = 2;
                break;
            }
            case 2: {
                this.resp[3] = 3;
                this.resp[4] = 127;
                int n3 = this.netBoot.nextResRec(this.resp, 5, 128);
                if (n3 > 0) break;
                if (this.netBoot.hasBnk()) {
                    this.state = 3;
                    break;
                }
                if (this.org0 != null) {
                    this.state = 5;
                    break;
                }
                this.state = 7;
                break;
            }
            case 3: {
                int n4 = this.netBoot.startBnkAddr();
                this.resp[3] = 2;
                this.resp[4] = 1;
                this.resp[5] = (byte)n4;
                this.resp[6] = (byte)(n4 >> 8);
                this.state = 4;
                break;
            }
            case 4: {
                this.resp[3] = 3;
                this.resp[4] = 127;
                int n5 = this.netBoot.nextBnkRec(this.resp, 5, 128);
                if (n5 > 0) break;
                if (this.org0 != null) {
                    this.state = 5;
                    break;
                }
                this.state = 7;
                break;
            }
            case 5: {
                int n6 = this.org0Adr;
                this.resp[3] = 2;
                this.resp[4] = 1;
                this.resp[5] = (byte)n6;
                this.resp[6] = (byte)(n6 >> 8);
                n6 = this.netBoot.entryAddr();
                this.org0[3] = (byte)n6;
                this.org0[4] = (byte)(n6 >> 8);
                this.curdma = 0;
                this.reccnt = this.org0.length / 128;
                this.state = 6;
                break;
            }
            case 6: {
                this.resp[3] = 3;
                this.resp[4] = 127;
                System.arraycopy(this.org0, this.curdma, this.resp, 5, 128);
                this.curdma += 128;
                --this.reccnt;
                if (this.reccnt > 0) break;
                this.state = 7;
                break;
            }
            case 7: {
                int n7 = this.org0 != null ? this.org0Adr : this.netBoot.entryAddr();
                this.resp[3] = 4;
                this.resp[4] = 1;
                this.resp[5] = (byte)n7;
                this.resp[6] = (byte)(n7 >> 8);
                this.state = -1;
                break;
            }
            default: {
                this.state = -1;
                return NetworkBoot.error(byArray);
            }
        }
        this.resp[0] = -79;
        this.resp[1] = byArray[2];
        this.resp[2] = byArray[1];
        return this.resp;
    }
}

