/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class NetworkDump {
    public static final int FMT = 208;
    static final int RECLEN = 128;
    private static SimpleDateFormat timestamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private RandomAccessFile dump;
    private byte[] resp;

    public NetworkDump(byte[] byArray, RandomAccessFile randomAccessFile) {
        this.dump = randomAccessFile;
        this.resp = new byte[133];
    }

    public static NetworkDump doStart(Properties properties, byte[] byArray) {
        String string = properties.getProperty("netdump_dir");
        if (string == null) {
            string = System.getProperty("user.home") + "/NetDump";
        }
        int n = byArray[2] & 0xFF;
        String string2 = timestamp.format(new Date());
        File file = new File(String.format("%s/cid_%02X-%s.dmp", string, n, string2));
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            System.err.format("Client %02x dumping to file \"%s\"\n", n, file.getAbsolutePath());
            return new NetworkDump(byArray, randomAccessFile);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] error(byte[] byArray) {
        return new byte[]{-47, byArray[2], byArray[1], 0, 0, 0};
    }

    public boolean done() {
        return this.dump == null;
    }

    public byte[] doNext(byte[] byArray) {
        if (this.dump == null) {
            return NetworkDump.error(byArray);
        }
        int n = byArray[3] & 0xFF;
        this.resp[3] = 1;
        switch (n) {
            case 2: {
                int n2 = byArray[5] & 0xFF | (byArray[6] & 0xFF) << 8;
                try {
                    this.dump.seek(n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.resp[3] = 0;
                    this.dump = null;
                }
                break;
            }
            case 3: {
                try {
                    this.dump.write(byArray, 5, 128);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.resp[3] = 0;
                    this.dump = null;
                }
                break;
            }
            case 4: {
                try {
                    this.dump.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.dump = null;
                break;
            }
            default: {
                return NetworkDump.error(byArray);
            }
        }
        this.resp[0] = -47;
        this.resp[1] = byArray[2];
        this.resp[2] = byArray[1];
        this.resp[4] = 0;
        return this.resp;
    }
}

